<?php
/* --------------------------------------------------------------
   GambioHubLogin.inc.php 2025-05-14
   http://www.gambio.de
   Copyright (c) 2017 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * extend Gambio login page using customer password as encryption key to 
 * encrypt sensitive payment tokens.
 */
class GambioHubLogin extends GambioHubLogin_parent
{
    public function proceed()
    {
        parent::proceed();
        $this->appendCustomerEncryptionKeyToSession();
    }

    /**
     * Generate encryption key for login email + password
     * 
     * @return void
     */
    private function appendCustomerEncryptionKeyToSession()
    {
        try {
            if ((basename($_SERVER['SCRIPT_FILENAME']) === 'login.php') && ($_SERVER['REQUEST_METHOD'] === 'POST')) {
                // login failed
                if (empty($_SESSION['customer_id'])) {
                    return;
                }
                // Only handle login via email password, ignore social login
                $email = $this->v_data_array['POST']['email_address'] ?? null;
                $password = $this->v_data_array['POST']['password'] ?? null;
                if (empty($email) || empty($password)) {
                    return;
                }
                $keyGenerator = MainFactory::create('HubKeyGenerator');
                $encryptionKey = $keyGenerator->generateCustomerEncryptionKey($email, $password);
                if ($encryptionKey) {
                    $_SESSION['customer_encryption_key'] = $encryptionKey;
                }
            }
        } catch (Exception $exception) {
            return;
        }
    }
}

